function CRLBstore = FisherCRLB(rateparams,thetastore,readnoisevariance)
% This function calculates the Fisher-matrix and the Cramer-Rao Lower Bound
% for the parameters found. 

% (C) Copyright 2018
% All rights reserved
% Department of Imaging Physics
% Faculty of Applied Sciences
% Delft University of Technology
% Delft, The Netherlands   

[Ncfg,numparams] = size(thetastore);
CRLBstore = zeros(numparams,numparams,Ncfg);
rcondstore = zeros(Ncfg,1);
for jcfg = 1:Ncfg

  theta = thetastore(jcfg,:);
  
% calculation Poisson rates
  [mu,dmudtheta] = poissonrate(rateparams,theta);
    
  keps = 1e3*eps;
  mu = mu+readnoisevariance;
  mupos = double(mu>0).*mu + double(mu<0)*keps;
  weight = 1./mupos;
  
  % calculation Fisher matrix
  Fisher = zeros(numparams,numparams);
  for ii = 1:numparams
    for jj = ii:numparams
      Fisher(ii,jj) = sum(sum(weight.*dmudtheta(:,:,ii).*dmudtheta(:,:,jj)));
      Fisher(jj,ii) = Fisher(ii,jj);
    end
  end
 
% regularization Fisher-matrix in order to circumvent possibility for
% inverting ill-conditioned matrix
  if (rcond(Fisher)>keps)
    CRLBstore(:,:,jcfg) = inv(Fisher+keps*eye(size(Fisher)));
  end
  rcondstore(jcfg) = rcond(Fisher);
  
end


